/*
	Copyright (C) MOXA Inc. All rights reserved.

	This software is distributed under the terms of the
	MOXA License.  See the file COPYING-MOXA for details.
*/
#pragma once
#include <iostream>
#include <string>
using namespace std;

#ifdef __cplusplus    // If used by C++ code, 
extern "C" {          // we need to export the C interface
#endif
	enum SIM_STATUS
	{
		SIM_SLOT1 = 1,
		SIM_SLOT0 = 0,
		LIB_INITIALIZE_FAIL = -1,
		PORT_OUTOF_INDEX = -2,
		SET_SLOT_ERR = -3,
		SET_STATUS_ERR = -4
	};

	HMODULE GetCurrentModule();
	int InitMXSIM(void);
	int GetSIMSlot(int port);
	int SetSIMSlot(int port, int slot);

	WORD GetNrVendorConfigFromModule(int port);
	int GetNrVendorIndexFromProfile(int port, WORD config);
	int SetM2BMainPower(int port, int value);
	int CheckModuleStatus(int port);
	int SetModulePower(int port, int value);
	int PowerOn(int port);
	int PowerOff(int port);

	bool CheckModuleValidation(int port);
	int Get5GPowerStatus(int port);
	int Set5GPowerStatus(int port, int status);

#ifdef __cplusplus    // If used by C++ code, 
}
#endif
