/*
	Copyright (C) MOXA Inc. All rights reserved.

	This software is distributed under the terms of the
	MOXA License.  See the file COPYING-MOXA for details.
*/

#include <windows.h>
#include "mxwdg.h"
#include <tchar.h>

int _tmain(int argc, _TCHAR* argv[])
{
	PVOID fd; // Handle to device, obtain from mxwdg_open
	ULONG time;

	// starts watchdog timer
	time = 10;
	fd = mxwdg_open(time);

	while (TRUE)
	{
		_tprintf(_T("Press \"ENTER\" in 10 seconds\n, 'q' to exit"));
		TCHAR ch = _gettchar();
		if (ch == (TCHAR)'q')
		{
			break;
		}

		// refresh watchdog timer
		mxwdg_refresh(fd);
	}

	// stops watchdog timer
	mxwdg_close(fd);
	return 0;
}

