#!/bin/bash -e
#
# Copyright (C) 2024 MOXA Inc. All rights reserved.
# This software is distributed under the terms of the MOXA SOFTWARE NOTICE.
# See the file LICENSE for details.
#

source "${INSTL_SCRIPT_DIR}/lib/logger.sh"
log::init "${INSTL_LOG_FILE}" "${INSTL_LOG_LEVEL}"

main() {
        if ! printenv PATH | grep -qw "/usr/sbin"; then
                log::warn "Please add \"/usr/sbin\" to PATH variable"
                export PATH=$PATH:/usr/sbin
        fi

        # set auto restart service in needrestart
        # let apt install/upgrade auto restart services and do not ask user
        if util::is_exists "/etc/needrestart/needrestart.conf"; then
                log::info "Set auto restart service in needrestart"
                sed -i "s/#\$nrconf{restart} = 'i';/\$nrconf{restart} = 'a';/g" /etc/needrestart/needrestart.conf
        fi
}

main
