/**
 * @file mcm-eth-info.h
 *
 * This library is for Moxa Connection Management
 *
 * @author York LY Chang <YorkLY.Chang@moxa.com>
 */

#ifndef _MCM_ETH_INFO_H_
#define _MCM_ETH_INFO_H_
#include "mcm-base-info.h"
/**
 * @brief A help function for get all ethernet properties.
 *
 * @param interfaceName (input) Interface name.
 *
 * @param arr_len (output) Number of properties array.
 *
 * @param info_arr (output) Properties array.
 *
 * @return If get ethernet properties success return 0. If fail, return error number.
 */
int mcm_ethernet_get_all_properties(char *interfaceName, int *arr_len, mcm_property_info **info_arr);

/**
 * @brief A help function for get property.
 *
 * @param interfaceName (input) Interface name.
 *
 * @param propertyName (input) Property name.
 *
 * @param cached (input) Using caeched property value.
 *
 * @param propertyValue (output) Property value.
 *
 * @return If get ethernet property success return 0. If fail, return error number.
 *
 */
int mcm_ethernet_get_property(char *interfaceName, char *propertyName, char **propertyValue, int cached);

/**
 * @brief A help function for get ethernet information.
 *
 * @param interfaceName (input) Interface name.
 *
 * @param ethernet_info (output) A ethernet infomation structure.
 *
 * @return If get ethernet properties success return 0. If fail, return error number.
 */
int mcm_get_ethernet_info(char *interfaceName, mcm_ethernet_info *ethernet_info);

#endif
