#!/bin/bash
#
# Copyright (C) 2023 MOXA Inc. All rights reserved.
# This software is distributed under the terms of the MOXA SOFTWARE NOTICE.
# See the file LICENSE for details.
#
# Authors:
#       2023  Wilson YS Huang  <wilsonys.huang@moxa.com>

# shellcheck disable=SC2317 # Don't warn about unreachable commands in this file

source "${INSTL_SCRIPT_DIR}/lib/util.sh"
source "${INSTL_SCRIPT_DIR}/lib/logger.sh"
log::init "${INSTL_LOG_FILE}" "${INSTL_LOG_LEVEL}"

set -e

process_file_test() {
        local repo_name="$1"
        local repo_tag="$2"
        local repo_ver

        if util::is_exists "${INSTL_SRC_VERSION_FILE}" && grep -wq "${repo_name}" "${INSTL_SRC_VERSION_FILE}"; then
                repo_ver=$(grep -w "${repo_name}" "${INSTL_SRC_VERSION_FILE}" | awk -F ':' '{print $2}')
        else
                repo_ver="N/A"
        fi

        log::info "$(printf " %-30s%-15s%-15s%-25s\n" "${repo_name}" "" "" "${repo_ver}")"

        source "${INSTL_SCRIPT_DIR}/self-test.d/${repo_name}.test.sh" "${repo_tag}"

        return 0
}

main() {
        local drivers_list
        local tools_list
        local driver_available
        local tool_available

        driver_available=true
        tool_available=true

        log::info "$(printf "%75s" " " | tr ' ' '-')"
        log::info "$(printf " %-30s%-15s%-15s%-25s\n" "Name" "Installed" "Status" "Version")"
        log::info "$(printf "%75s" " " | tr ' ' '=')"

        drivers_list="${INSTL_PRODUCT_DIR}/${PRODUCT_NAME}/drivers"
        if ! util::parse_product_file "${drivers_list}" "${LINUX_KERNEL_MAJOR_VER}" "${LINUX_KERNEL_MINOR_VER}" process_file_test; then
                driver_available=false
        fi

        tools_list="${INSTL_PRODUCT_DIR}/${PRODUCT_NAME}/tools"
        if ! util::parse_product_file "${tools_list}" "${LINUX_KERNEL_MAJOR_VER}" "${LINUX_KERNEL_MINOR_VER}" process_file_test; then
                tool_available=false
        fi

        if [[ $driver_available = false ]] && [[ $tool_available = false ]]; then
                log::info "$(printf " %-30s%-15s%-15s%-25s\n" "No available" "N/A" "N/A" "N/A")"
        fi

        log::info "$(printf "%75s" " " | tr ' ' '-')"

        exit 0
}

main
