#!/bin/bash
#
# Copyright (C) 2024 MOXA Inc. All rights reserved.
# This software is distributed under the terms of the MOXA SOFTWARE NOTICE.
# See the file LICENSE for details.
#
# Authors:
#       2024  Elvis Yao  <elviscw.yao@moxa.com>

source "${INSTL_SCRIPT_DIR}/lib/util.sh"
source "${INSTL_SCRIPT_DIR}/lib/logger.sh"
log::init "${INSTL_LOG_FILE}" "${INSTL_LOG_LEVEL}"

set -e

REPO_NAME="moxa-gpio-pca953x-driver"
MOD_NAME="gpio-pca953x"

main() {
        local src_ver
        src_ver="$2"

        log::info "Uninstall ${REPO_NAME} ($src_ver)"

        if util::is_exists "/lib/modules/$(uname -r)/kernel/drivers/gpio/${MOD_NAME}.ko"; then
                log::debug "Remove ${MOD_NAME}.ko"
                rm -f "/lib/modules/$(uname -r)/kernel/drivers/gpio/${MOD_NAME}.ko"
        fi

        if util::is_exists "/usr/lib/modules-load.d/${MOD_NAME}.conf"; then
                log::debug "Remove ${MOD_NAME}.conf"
                rm -f "/usr/lib/modules-load.d/${MOD_NAME}.conf"
        fi
}

main "$@"
