# Moxa MCU Manager (MMM)

## Setup environment
1. Install build tool
```
sudo apt-get install build-essential autoconf make
```
2. Configure the project
```
./autogen.sh
./configure --with-systemdsystemunitdir=/lib/systemd/system
```
3. Compile the project
```
make && make install
```

## Starting the systemd Service
1. Reload systemd configuration
```
sudo systemctl daemon-reload
```

2. Enable the service
```
sudo systemctl enable moxa-mcu-manager.service
```

3. Start the service
```
sudo systemctl start moxa-mcu-manager.service
```

## Debug log for developing
1. Toggle debug level via signal SIGHUP
```
kill -HUP $(pidof mx-mcud)
```

2. Monitor log
```
journalctl -f -u moxa-mcu-manager
```