#!/bin/bash

MCU_TOOL="mx-mcu-mgmt"
MCU_FW_VERSION="1.0.0[S08]"

print_result() {
    if [ $1 -eq 0 ]; then
        printf "\r[\e[32mPASS\e[0m] $2\n"
    else
        printf "\r[\e[31mFAIL\e[0m] $2\n"
    fi
}

run_test() {
    printf "[TEST] $1"
    output=$($1 2>&1)
    ret=$?
    expect=$2

    if [ "$output" == "$expect" ] && [ $ret -eq 0 ]; then
        print_result 0 "$1"
    else
        print_result 1 "$1"
    fi
}

run_test "$MCU_TOOL mcu_version" "$MCU_FW_VERSION"

run_test "$MCU_TOOL app_wdt_timeout set_timeout 5"
run_test "$MCU_TOOL app_wdt_timeout get_timeout" "5"
run_test "$MCU_TOOL app_wdt_timeout set_timeout 10"
run_test "$MCU_TOOL app_wdt_timeout get_timeout" "10"
run_test "$MCU_TOOL app_wdt_timeout set_timeout 15"
run_test "$MCU_TOOL app_wdt_timeout get_timeout" "15"

run_test "$MCU_TOOL relay set_mode connect"
run_test "$MCU_TOOL relay get_mode" "connect"
run_test "$MCU_TOOL relay set_mode disconnect"
run_test "$MCU_TOOL relay get_mode" "disconnect"
run_test "$MCU_TOOL relay set_mode bypass"
run_test "$MCU_TOOL relay get_mode" "bypass"

run_test "$MCU_TOOL wdt_relay set_mode connect"
run_test "$MCU_TOOL wdt_relay get_mode" "connect"
run_test "$MCU_TOOL wdt_relay set_mode disconnect"
run_test "$MCU_TOOL wdt_relay get_mode" "disconnect"
run_test "$MCU_TOOL wdt_relay set_mode bypass"
run_test "$MCU_TOOL wdt_relay get_mode" "bypass"

run_test "$MCU_TOOL poweroff_relay set_mode disconnect"
run_test "$MCU_TOOL poweroff_relay get_mode" "disconnect"
run_test "$MCU_TOOL poweroff_relay set_mode bypass"
run_test "$MCU_TOOL poweroff_relay get_mode" "bypass"

run_test "$MCU_TOOL app_wdt_relay set_mode connect"
run_test "$MCU_TOOL app_wdt_relay get_mode" "connect"
run_test "$MCU_TOOL app_wdt_relay set_mode disconnect"
run_test "$MCU_TOOL app_wdt_relay get_mode" "disconnect"
run_test "$MCU_TOOL app_wdt_relay set_mode bypass"
run_test "$MCU_TOOL app_wdt_relay get_mode" "bypass"

run_test "$MCU_TOOL app_wdt_timeout set_timeout 0"
run_test "$MCU_TOOL app_wdt_timeout get_timeout" "disabled"
