# Moxa x86 Linux SDK Wizard

The Moxa x86 Linux SDK enables the easy deployment on the Moxa x86 IPC platform.  
The SDK contains components for peripheral drivers, peripheral control tools and configuration files.  
It also provides deployment features, such as build & installation log, dry-run, and selftest on target model.

# Extract Moxa x86 Linux SDK Wizard

```
apt update && apt install unzip
unzip Moxa_x86_Linux_SDK_<sdk_ver>_Build_<sdk_builddate>.zip
cd Moxa_x86_Linux_SDK_<ver>_Build_<builddate>
tar xvf Moxa_x86_Linux_Install_Wizard_<wiz_ver>_Build_<wiz_builddate>.tgz
cd Moxa_x86_Linux_Install_Wizard_<wiz_ver>_Build_<wiz_builddate>
```

# Usage
Show a short usage summary

- Command
```
./install.sh --help
```
- Result
```

                ███╗   ███╗ ██████╗ ██╗  ██╗ █████╗
                ████╗ ████║██╔═══██╗╚██╗██╔╝██╔══██╗
                ██╔████╔██║██║   ██║ ╚███╔╝ ██║  ██║
                ██║╚██╔╝██║██║   ██║ ██╔██╗ ██║  ██║
                ██║ ╚═╝ ██║╚██████╔╝██╔╝ ██╗██║  ██║
                ╚═╝     ╚═╝ ╚═════╝ ╚═╝  ╚═╝╚═╝  ╚═╝
                ------------------------------------
                         X86 INSTALL WIZARD

Usage: install.sh [option]

Options:
        -h, --help         Display this help page
        -y, --yes          Automatically answer yes
        -v, --version      Display the version information
        -s, --selftest     Run the self test cases
            --dry-run      List available driver and tool only
            --uninstall    Uninstall driver and tool
            --force        Install driver and tool even if the
                           version is the same or older (default is
                           to install newer version)

Without passing any option, it would run the installation directly.
```

## Display x86 Install Wizard version

- Command
```
./install.sh --version
```
- Expected result
```
1.0.0
```

## How to Use the `--yes` Option
The `--yes` (alternatively, `-y`) option automatically answers yes to any prompts

It can use with others options as below
- Assume "yes" as answer to all prompts during installation process
```
./install.sh --yes
```
- Assume "yes" as answer to all prompts during uninstallation process
```
./install.sh --yes --uninstall
```

## How to Use the `--dry-run` Option
The `--dry-run` option simulates what would install, but doesn't actually change anything on your system

- Command
```
./install.sh --dry-run
```
- Expected result (RKP-A110)
  - Name: driver or tool source name
  - Version: driver or tool source version which is available to install
  - Tag: driver or tool source git tag name
```
----------------------------------------------------------------------
 Product Name: RKPA110
----------------------------------------------------------------------
 Name                          Version                  Tag
======================================================================
 moxa-it87-gpio-driver         5.2+1.5.0-1              master
 moxa-it87-wdt-driver          5.2+1.5.0-1              5.2-master
 moxa-it87-serial-driver       1.4.1+u2                 master
 moxa-mxuport-driver           5.1.1_build_23080316     5.x-5.1.1_build_23080316-develop
 moxa-x86-control-tools        1.8.1                    master
----------------------------------------------------------------------
```

## Build and Install
Default is to install newer version. If you want to install the same or older, please use the `--force` option

- Command
```
./install.sh
```
> Note: Please run with **sudo/root** privileges

- Expected result (RKP-A110)
```
[info] Product Name: RKPA110
[info] OS Name: Ubuntu
[info] OS Version: 22.04
[info] Kernel Info: Linux moxa 5.19.0-32-generic #33~22.04.1-Ubuntu SMP PREEMPT_DYNAMIC Mon Jan 30 17:03:34 UTC 2 x86_64 x86_64 x86_64 GNU/Linux
Do you want to continue? [Y/n]y
[info] >>> Execute hook script "install-dev-tools.sh".
[info] <<< Execute hook script "install-dev-tools.sh" done.
[info] >>> Execute hook script "build-and-install-source.sh".
[info] === Run pre-install
[info] === Install driver
Do you want to install moxa-it87-gpio-driver (5.2+1.5.0-1)? [Y/n]y
[info] Installing moxa-it87-gpio-driver (5.2+1.5.0-1)
Do you want to install moxa-it87-wdt-driver (5.2+1.5.0-1)? [Y/n]y
[info] Installing moxa-it87-wdt-driver (5.2+1.5.0-1)
...
... (skip)
...
[info] Done. Please reboot machine for installation to take effect.
Do you want to reboot now? [Y/n]
```
And finally, you'll see a prompt asking if you want to reboot the system

```
Do you want to reboot now? [Y/n]
```

Enter `y`, `Y`, or `yes` to reboot the system, or `n`, `N`, or `no` to exit out of install process

## Check the status of deployment
After build and install, you can run `--selftest` option to check the status.

- Command
```
./install.sh --selftest
```
- Expected result (RKP-A110)
  - Name: Driver or tool name
  - Installed: Installation status of the driver or tool
    - Yes: The driver/tool is installed
    - No: The driver/tool is not installed
  - Status: Shows the readiness of the installed driver or tool
    - Loaded: The driver is loaded
    - Active: The tool or service is active
  - Version: Version: The version of the driver or tool

```
[info] Product Name: RKPA110
[info] OS Name: Ubuntu
[info] OS Version: 22.04
[info] Kernel Info: Linux moxa 5.19.0-32-generic #33~22.04.1-Ubuntu SMP PREEMPT_DYNAMIC Mon Jan 30 17:03:34 UTC 2 x86_64 x86_64 x86_64 GNU/Linux
[info] >>> Execute hook script "self-test.sh".
[info] ---------------------------------------------------------------------------
[info]  Name                          Installed      Status         Version
[info] ===========================================================================
[info]  moxa-it87-gpio-driver                                       5.2+1.5.0-1
[info]  - gpio_it87                   Yes            Loaded
[info]  moxa-it87-wdt-driver                                        5.2+1.5.0-1
[info]  - it87_wdt                    Yes            Loaded
[info]  - watchdog service            Yes            Active
[info]  moxa-it87-serial-driver                                     1.4.1+u2
[info]  - it87_serial                 Yes            Loaded
[info]  moxa-mxuport-driver                                         5.1.1_build_23080316
[info]  - mxuport                     Yes            Loaded
[info]  moxa-x86-control-tools                                      1.8.1
[info]  - mx-uart-ctl                 Yes            6 ports
[info]  - mx-dio-ctl                  Yes            8 DI / 8 DO
[info] ---------------------------------------------------------------------------
[info] <<< Execute hook script "self-test.sh" done.
```

## Uninstall
Uninstall is identical to install except that driver and tool are removed instead of installed

- Command
```
./install.sh --uninstall
```
> Note: Please run with **sudo/root** privileges

- Expected result (RKP-A110)
```
[info] Product Name: RKPA110
[info] OS Name: Ubuntu
[info] OS Version: 22.04
[info] Kernel Info: Linux moxa 5.19.0-32-generic #33~22.04.1-Ubuntu SMP PREEMPT_DYNAMIC Mon Jan 30 17:03:34 UTC 2 x86_64 x86_64 x86_64 GNU/Linux
Do you want to continue? [Y/n]y
[info] >>> Execute hook script "uninstall.sh".
[info] === Uninstall driver
Do you want to uninstall moxa-it87-gpio-driver (5.2+1.5.0-1)? [Y/n]y
[info] Uninstall moxa-it87-gpio-driver (5.2+1.5.0-1)
Do you want to uninstall moxa-it87-wdt-driver (5.2+1.5.0-1)? [Y/n]y
[info] Uninstall moxa-it87-wdt-driver (5.2+1.5.0-1)
[info]  Remove Watchdog Service
Do you want to uninstall moxa-it87-serial-driver (1.4.1+u2)? [Y/n]y
[info] Uninstall moxa-it87-serial-driver (1.4.1+u2)
...
... (skip)
...
[info] <<< Execute hook script "uninstall.sh" done.
[info] Done. Please reboot machine for uninstallation to take effect.
Do you want to reboot now? [Y/n]
```
And finally, you'll see a prompt asking if you want to reboot the system

```
Do you want to reboot now? [Y/n]
```

Enter `y`, `Y`, or `yes` to reboot the system, or `n`, `N`, or `no` to exit out of uninstall process

## Log file
Finally, if user wants to see the log of build and install stage, the log file is located on the same build folder **install.log**

- Command
```
cat install.log
```

# Moxa x86 Linux Software User Manual

See `docs` folder for Moxa x86 Linux Software User Manuals.
