#!/bin/bash -e
#
# Copyright (C) 2023 MOXA Inc. All rights reserved.
# This software is distributed under the terms of the MOXA SOFTWARE NOTICE.
# See the file LICENSE for details.
#

set -e

source "${INSTL_SCRIPT_DIR}/lib/logger.sh"
source "${INSTL_SCRIPT_DIR}/lib/util.sh"
log::init "${INSTL_LOG_FILE}" "${INSTL_LOG_LEVEL}"

main() {
        log::info "Install hardware sensor monitor lm-sensors packages"
        {
                case "${OS_PACKAGE_MANAGER}" in
                "apt") apt-get install -y "lm-sensors" ;;
                "yum") yum install -y "lm_sensors" ;;
                esac
        } >>"${INSTL_LOG_FILE}" 2>&1

        {
                systemctl daemon-reload
                systemctl disable moxa-cellular-power-control@0.service
                systemctl disable moxa-cellular-power-control@1.service

                # Update udev rules
                udevadm control --reload-rules
                udevadm trigger
        } >>"${INSTL_LOG_FILE}" 2>&1

        # Update modules dependence
        depmod -a
}

main
