#!/bin/bash
#
# Copyright (C) 2023 MOXA Inc. All rights reserved.
# This software is distributed under the terms of the MOXA SOFTWARE NOTICE.
# See the file LICENSE for details.
#
# Authors:
#       2024  Elvis Yao  <elviscw.yao@moxa.com>

source "${INSTL_SCRIPT_DIR}/lib/util.sh"
source "${INSTL_SCRIPT_DIR}/lib/logger.sh"
source "${INSTL_SCRIPT_DIR}/lib/driver.sh"
log::init "${INSTL_LOG_FILE}" "${INSTL_LOG_LEVEL}"

set -e

REPO_NAME="moxa-mxser-driver"
SRC_PATH_PREFIX="${INSTL_TOP_DIR}/src/${REPO_NAME}"

main() {
        local src_tag
        local src_ver
        src_tag="$1"
        src_ver="$2"

        log::info "Installing ${REPO_NAME} (${src_ver})"
        {
                pushd "${SRC_PATH_PREFIX}-${src_tag}" >/dev/null
                [[ ! -x mxinstall ]] && chmod +x mxinstall
                yes | ./mxinstall

                # Compress module if kernel config compress type is enabled
                drv_path=$(modinfo -n mxser 2>/dev/null || true)
                drv::compress_module "$drv_path"

                popd

                pushd "${SRC_PATH_PREFIX}-${src_tag}/utility" >/dev/null
                make && make install
                popd
        } >>"${INSTL_LOG_FILE}" 2>&1
}

main "$@"
