#!/bin/bash
#
# Copyright (C) 2023 MOXA Inc. All rights reserved.
# This software is distributed under the terms of the MOXA SOFTWARE NOTICE.
# See the file LICENSE for details.
#
# Authors:
#       2023  Wilson YS Huang  <wilsonys.huang@moxa.com>

source "${INSTL_SCRIPT_DIR}/lib/util.sh"
source "${INSTL_SCRIPT_DIR}/lib/logger.sh"
log::init "${INSTL_LOG_FILE}" "${INSTL_LOG_LEVEL}"

set -e

TEST_LIST=(
        "gpiodetect"
        "gpioget"
        "gpioinfo"
        "gpiomon"
        "gpionotify"
        "gpioset")

main() {
        for g in "${TEST_LIST[@]}"; do
                if command -v "${g}" >/dev/null 2>&1; then
                        log::info "$(printf " %-50s$(colors::green %-15s)%-25s\n" "- ${g}" "Yes" "N/A")"
                else
                        log::info "$(printf " %-50s$(colors::red %-15s)%-25s\n" "- ${g}" "No" "N/A")"
                fi
        done
}

main "$@"
