#!/bin/bash
#
# Copyright (C) 2024 MOXA Inc. All rights reserved.
# This software is distributed under the terms of the MOXA SOFTWARE NOTICE.
# See the file LICENSE for details.
#
# Authors:
#       2024  Henry LC Chen  <henrylc.chen@moxa.com>

source "${INSTL_SCRIPT_DIR}/lib/util.sh"
source "${INSTL_SCRIPT_DIR}/lib/logger.sh"
log::init "${INSTL_LOG_FILE}" "${INSTL_LOG_LEVEL}"

set -e

REPO_NAME="intel-gpu-i915-backports"

main() {
        local src_ver
        src_ver="$2"

        log::info "Uninstall ${REPO_NAME} ($src_ver)"

        {
                case "${OS_PACKAGE_MANAGER}" in
                "apt")
                        apt remove -y intel-i915-dkms
                        ;;
                "yum")
                        yum remove -y intel-i915-dkms
                        ;;
                esac
        } >>"${INSTL_LOG_FILE}" 2>&1
}

main "$@"
