#!/bin/bash
#
# Copyright (C) 2023 MOXA Inc. All rights reserved.
# This software is distributed under the terms of the MOXA SOFTWARE NOTICE.
# See the file LICENSE for details.
#
# Authors:
#       2024  Wilson YS Huang  <wilsonys.huang@moxa.com>

source "${INSTL_SCRIPT_DIR}/lib/util.sh"
source "${INSTL_SCRIPT_DIR}/lib/logger.sh"
log::init "${INSTL_LOG_FILE}" "${INSTL_LOG_LEVEL}"

set -e

REPO_NAME="moxa-irigb-driver"

main() {
        local src_ver
        src_ver="$2"

        log::info "Uninstall ${REPO_NAME} ($src_ver)"

        if util::is_exists "/lib/modules/$(uname -r)/kernel/drivers/gpio/moxa_irigb.ko"; then
                log::debug "Remove moxa_irigb.ko"
                rm -f "/lib/modules/$(uname -r)/kernel/drivers/gpio/moxa_irigb.ko"
        fi

        if util::is_exists "/usr/lib/modules-load.d/moxa_irigb.conf"; then
                log::debug "Remove moxa_irigb.conf"
                rm -f "/usr/lib/modules-load.d/moxa_irigb.conf"
        fi
}

main "$@"
