#!/bin/bash
#
# Copyright (C) 2023 MOXA Inc. All rights reserved.
# This software is distributed under the terms of the MOXA SOFTWARE NOTICE.
# See the file LICENSE for details.
#
# Authors:
#       2023  Wilson YS Huang  <wilsonys.huang@moxa.com>

source "${INSTL_SCRIPT_DIR}/lib/util.sh"
source "${INSTL_SCRIPT_DIR}/lib/logger.sh"
log::init "${INSTL_LOG_FILE}" "${INSTL_LOG_LEVEL}"

set -e

REPO_NAME="moxa-it87-wdt-driver"

main() {
        local src_ver
        src_ver="$2"

        log::info "Uninstall ${REPO_NAME} ($src_ver)"

        if util::is_exists "$(modinfo -n it87_wdt)" >/dev/null 2>&1; then
                log::debug "Remove it87_wdt.ko"
                rm -f "$(modinfo -n it87_wdt)"
        fi

        if util::is_exists "/lib/modules-load.d/it87_wdt.conf"; then
                log::debug "Remove it87_wdt.conf"
                rm -f "/lib/modules-load.d/it87_wdt.conf"
        fi

        if util::is_exists "/lib/modprobe.d/it87_wdt-option.conf"; then
                log::debug "Remove it87_wdt-option.conf"
                rm -f "/lib/modprobe.d/it87_wdt-option.conf"
        fi

        if util::is_exists "/lib/modprobe.d/blacklist-wdt.conf"; then
                log::debug "Remove blacklist-wdt.conf"
                rm -f "/lib/modprobe.d/blacklist-wdt.conf"
        fi

        log::info " Disable Watchdog Service"
        {
                if [[ "${LINUX_DISTRO_ID}" != "centos" ]]; then
                        if util::is_exists "/etc/watchdog.conf"; then
                                log::debug "Remove 'watchdog-device' in '/etc/watchdog.conf'"
                                sed -i "s/watchdog-device/#watchdog-device/g" /etc/watchdog.conf
                        fi
                        systemctl disable watchdog.service
                fi
        } >>"${INSTL_LOG_FILE}" 2>&1
}

main "$@"
