
# Supported Vanilla LTS kernels
  Our current backport supports the following Vanilla LTS kernels.


| OS Distribution | Kernel Version  |
|---  |---  |
| Vanilla | 6.1 LTS  |
| Vanilla | 5.15 LTS |


  The kernel header used at the time of backporting may not be compatible with the latest version at the time of installation.
  Please refer [Version](https://github.com/intel-gpu/intel-gpu-i915-backports/blob/backport/main/versions) file to check value of VANILLA_6.1LTS_KERNEL_VERSION or VANILLA_5.15LTS_KERNEL_VERSION for Vanilla. It will point to the kernel version which is being used during backporting.

  In case of an issue with the latest kernel, please install the kernel version mentioned in version file for appropriate OS version.


Please note that dkms installation will skip if the kernel headers are not installed.

## Prerequisite
### Debian based package:
We have dependencies on the following packages
  - make
  - debhelper
  - devscripts
  - build-essential
  - flex
  - bison
  - awk

```
$sudo apt install make debhelper devscripts build-essential flex bison awk
```
### RPM based package:
We have dependencies on the following packages:
  - make
  - lsb-release
  - rpm-build
  - linux-glibc-devel
  - flex
  - bison
  - awk

```
$sudo dnf install make linux-glibc-devel lsb-release rpm-build bison flex awk

```
For dkms modules, we need to install `dkms` package also.
```
$sudo apt install dkms
or
$sudo dnf install dkms
```

## Out of tree kernel drivers
This repository contains following drivers.
1. Intel® Graphics Driver Backports(i915) - The main graphics driver (includes a compatible DRM subsystem and dmabuf if necessary)
2. Intel® Converged Security Engine(cse) - Converged Security Engine
3. Intel® Platform Monitoring Technology(pmt/vsec) - Intel Platform Telemetry


## Dependencies

  These drivers have dependency on Intel® GPU firmware and few more kernel mode drivers may be needed based on specific use cases, platform, and distributions. Source code of additional drivers should be available at https://github.com/intel-gpu

- [Intel® GPU firmware](https://github.com/intel-gpu/intel-gpu-firmware) - Firmware required by intel GPUs.

Each project is tagged consistently, so when pulling these repos, pull the same tag.

## Package creation
Both debian based and rpm based packages are supported.

### Dynamic Kernel Module Support(DKMS)
There are two ways to create i915 dkms packages.
1. Using default command :
```
$make i915dkmsdeb-pkg #debian package
or
$make i915dkmsrpm-pkg #rpm package
Example:
        $make i915dkmsdeb-pkg

      Generated package name :
                intel-i915-dkms_1.23.6.24.230425.29+i1-1_all.deb
```

2. OS distribution option:

    Adds OS kernel version as part of dkms pacakge name.
```
$make i915dkmsdeb-pkg OS_DISTRIBUTION=<os_distribution> #debian package
or
$make i915dkmsrpm-pkg OS_DISTRIBUTION=<os_distribution> #rpm package

Example:
        $make i915dkmsdeb-pkg OS_DISTRIBUTION=VANILLA_5.15LTS

      Generated package name :
                intel-i915-dkms_1.23.6.24.230425.29.5.15.123.53+i1-1_all.deb
```
Above cmd will create debain package in parent folder. **intel-i915-dkms_<**release version**>.<**kernel-version**>.deb**


### Binary package creation:
Creation of binary rpm can be done using the below command. By default it will use header of booted kernel, However it can be pointed to other headers via optional KLIB and KLIB_BUILD arguement

```
$make KLIB=<Header Path> KLIB_BUILD=<Header Path> binrpm-pkg
or
$make KLIB=<Header Path> KLIB_BUILD=<Header Path> bindeb-pkg

Exmaple:
$make KLIB=/lib/modules/$(uname -r) KLIB_BUILD=/lib/modules/$(uname -r) binrpm-pkg

Generated Files:
intel-i915-<version>.$(uname -r)-1.x86_64.rpm
```
## Package installation
```
$sudo dpkg -i intel-i915*.deb
or
$sudo rpm -ivh intel-i915*.rpm
```
#### Reboot the device after installation of all packages.
```
$sudo reboot
```
## Installation verification

Please grep **backport**  from dmesg after reboot. you should see something like below
```
> sudo dmesg |grep -i backport
[    5.963854] COMPAT BACKPORTED INIT
[    5.968761] Loading modules backported from I915_23.6.24
[    5.976154] Backport generated by backports.git I915_23.6.24_PSB_230425.29
[    6.069699] [drm] I915 BACKPORTED INIT
```
