/* SPDX-License-Identifier: MIT */
/*
 * Copyright © 2022 Intel Corporation
 */

#ifndef _ABI_IOV_COMMUNICATION_MMIO_ABI_H_
#define _ABI_IOV_COMMUNICATION_MMIO_ABI_H_

#include "gt/uc/abi/guc_communication_ctb_abi.h"

/**
 * DOC: IOV MMIO Communication
 *
 * The communication between VF and PF is based on GuC acting as a proxy agent.
 *
 * In case when `CTB based communication`_ is not yet available on VF side,
 * VF may initiate IOV relay using `GuC MMIO based communication`_.
 *
 * The `MMIO HXG Message`_ `VF2GUC_MMIO_RELAY_SERVICE`_ allows the VF to pass
 * @OPCODE and @DATA1..@DATA3 as a IOV relay data. Additional @MAGIC field will
 * be returned in any future replies and will help detect communication mismatch.
 *
 *  +--------------------------------------------------------------------------+
 *  |  `MMIO HXG Message`_                                                     |
 *  |                                                                          |
 *  +===+======================================================================+
 *  |   |  `HXG Request`_                                                      |
 *  |   |                                                                      |
 *  |   +---+------------------------------------------------------------------+
 *  |   |   |  `VF2GUC_MMIO_RELAY_SERVICE`_                                    |
 *  |   |   |                                                                  |
 *  |   |   +---+--------------------------------------------------------------+
 *  |   |   |   | MAGIC                                                        |
 *  |   |   |   |                                                              |
 *  |   |   |   +--------------------------------------------------------------+
 *  |   |   |   | OPCODE                                                       |
 *  |   |   |   |                                                              |
 *  |   |   |   +--------------------------------------------------------------+
 *  |   |   |   | DATA1..DATA3                                                 |
 *  |   |   |   |                                                              |
 *  +---+---+---+--------------------------------------------------------------+
 *
 * The IOV relay data together with requesting VF identifier is then send by the
 * GuC to the PF using `CTB HXG Message`_ GUC2PF_MMIO_RELAY_SERVICE_ for further
 * processing.
 *
 *  +--------------------------------------------------------------------------+
 *  |  `CTB HXG Message`_                                                      |
 *  |                                                                          |
 *  +===+======================================================================+
 *  |   |  `HXG Event`_                                                        |
 *  |   |                                                                      |
 *  |   +---+------------------------------------------------------------------+
 *  |   |   |  `GUC2PF_MMIO_RELAY_SERVICE`_                                    |
 *  |   |   |                                                                  |
 *  |   |   +---+--------------------------------------------------------------+
 *  |   |   |   | VFID                                                         |
 *  |   |   |   |                                                              |
 *  |   |   |   +--------------------------------------------------------------+
 *  |   |   |   | MAGIC                                                        |
 *  |   |   |   |                                                              |
 *  |   |   |   +--------------------------------------------------------------+
 *  |   |   |   | OPCODE                                                       |
 *  |   |   |   |                                                              |
 *  |   |   |   +--------------------------------------------------------------+
 *  |   |   |   | DATA1..DATA3                                                 |
 *  |   |   |   |                                                              |
 *  +---+---+---+--------------------------------------------------------------+
 *
 * After completing processing of the IOV relay data PF shall reply to the VF
 * using `CTB HXG Message`_ `PF2GUC_MMIO_RELAY_SUCCESS`_
 *
 *  +--------------------------------------------------------------------------+
 *  |  `CTB HXG Message`_                                                      |
 *  |                                                                          |
 *  +===+======================================================================+
 *  |   |  `HXG Request`_                                                      |
 *  |   |                                                                      |
 *  |   +---+------------------------------------------------------------------+
 *  |   |   |  `PF2GUC_MMIO_RELAY_SUCCESS`_                                    |
 *  |   |   |                                                                  |
 *  |   |   +---+--------------------------------------------------------------+
 *  |   |   |   | VFID                                                         |
 *  |   |   |   |                                                              |
 *  |   |   |   +--------------------------------------------------------------+
 *  |   |   |   | MAGIC                                                        |
 *  |   |   |   |                                                              |
 *  |   |   |   +--------------------------------------------------------------+
 *  |   |   |   | DATA0..DATA3                                                 |
 *  |   |   |   |                                                              |
 *  +---+---+---+--------------------------------------------------------------+
 *
 * or `CTB HXG Message`_ `PF2GUC_MMIO_RELAY_FAILURE`_
 *
 *  +--------------------------------------------------------------------------+
 *  |  `CTB HXG Message`_                                                      |
 *  |                                                                          |
 *  +===+======================================================================+
 *  |   |  `HXG Request`_                                                      |
 *  |   |                                                                      |
 *  |   +---+------------------------------------------------------------------+
 *  |   |   |  `PF2GUC_MMIO_RELAY_FAILURE`_                                    |
 *  |   |   |                                                                  |
 *  |   |   +---+--------------------------------------------------------------+
 *  |   |   |   | VFID                                                         |
 *  |   |   |   |                                                              |
 *  |   |   |   +--------------------------------------------------------------+
 *  |   |   |   | MAGIC                                                        |
 *  |   |   |   |                                                              |
 *  |   |   |   +--------------------------------------------------------------+
 *  |   |   |   | FAULT                                                        |
 *  |   |   |   |                                                              |
 *  +---+---+---+--------------------------------------------------------------+
 *
 * Above PF messages will be converted by the GuC back to `MMIO HXG Message`_
 * `HXG Response`_
 *
 *  +--------------------------------------------------------------------------+
 *  |  `MMIO HXG Message`_                                                     |
 *  |                                                                          |
 *  +===+======================================================================+
 *  |   | `HXG Response`_                                                      |
 *  |   |                                                                      |
 *  |   +---+------------------------------------------------------------------+
 *  |   |   |  MAGIC                                                           |
 *  |   |   |                                                                  |
 *  |   |   +------------------------------------------------------------------+
 *  |   |   |  DATA0..DATA3                                                    |
 *  |   |   |                                                                  |
 *  +---+---+------------------------------------------------------------------+
 *
 * or `MMIO HXG Message`_ `HXG Failure`_
 *
 *  +--------------------------------------------------------------------------+
 *  |  `MMIO HXG Message`_                                                     |
 *  |                                                                          |
 *  +===+======================================================================+
 *  |   | `HXG Failure`_                                                       |
 *  |   |                                                                      |
 *  |   +---+------------------------------------------------------------------+
 *  |   |   |  MAGIC (part of the HINT)                                        |
 *  |   |   |                                                                  |
 *  |   |   +------------------------------------------------------------------+
 *  |   |   |  FAULT (part of the ERROR)                                       |
 *  |   |   |                                                                  |
 *  +---+---+------------------------------------------------------------------+
 *
 */

#endif /* _ABI_IOV_COMMUNICATION_MMIO_ABI_H_ */
