/**
 * @file mcm-sim-unlock.h
 *
 * This library is for Moxa Connection Management
 *
 */
#ifndef _MCM_SIM_UNLOCK_H_
#define _MCM_SIM_UNLOCK_H_

/**
 * @brief A helper function to unlock PUK and reset SIM PIN.
 *
 * @param interfaceName (input) Interface name.
 *
 * @param puk (input) PUK.
 *
 * @param pin (input) PIN.
 *
 * @return If unlock PUK success return 0. If fail, return error number.
 *
 */
int mcm_sim_unlock_puk(char *interfaceName, char *puk, char *pin);

/**
 * @brief A helper function to Unlock SIM PIN .
 *
 * @param interfaceName (input) Interface name.
 *
 * @param pin (input) PIN.
 *
 * @return If unlock PIN success return 0. If fail, return error number.
 *
 */
int mcm_sim_unlock_pin(char *interfaceName, char *pin);
#endif