#!/bin/sh
#
# Load the MOXA EULA License when user first logins.

# * path and settings
USERNAME="moxa"
TITLE="MOXA END USER LICENSE AGREEMENT"
LICENSE_PATH="/usr/share/moxa-mil-base-system/LICENSE.txt"
LICENSE_CONF="/home/$USER/.moxa-license"

# * whiptail environment
DIM=$(stty size)
ROWS=${DIM%% *}
COLUMNS=${DIM##* }
LICENSE_MAX_COL=84

#######################################
# Show the whiptail license.
# Globals:
#   LICENSE_PATH
#   TITLE
#   ROW: stty row
#   COLUMNS: stty columns
# Arguments:
#   None
# Outputs:
#   None
#######################################
show_license() {
  # * Restrict the MAXIMUN COL
  if [ $COLUMNS -gt $LICENSE_MAX_COL ]; then
    COLUMNS=$LICENSE_MAX_COL
  fi

  if [ -f $LICENSE_PATH ]; then
    license=$(cat $LICENSE_PATH)
    if ! (whiptail --clear --scrolltext --title "$TITLE" \
          --yes-button "Accept" --no-button "Decline" \
          --yesno "$license" $ROWS $COLUMNS); then
      exit # force logout
    fi
  fi
}

#######################################
# Check license conf and show license.
# Globals:
#   LICENSE_CONF
# Arguments:
#   None
# Outputs:
#   Non
########################################
check_and_show_license() {
  if [ ! -f $LICENSE_CONF ]; then
    show_license
    echo -n >$LICENSE_CONF

    # * synchronize file cache
    sync -f $LICENSE_CONF
  fi
}

main() {
  # * Only apply for username = moxa
  if [ "$USER" = "$USERNAME" ]; then
    check_and_show_license
  fi
}

main