#!/bin/bash
#
# Copyright (C) MOXA Inc. All rights reserved.
# This software is distributed under the terms of the MOXA SOFTWARE NOTICE.
# See the file MOXA-SOFTWARE-NOTICE for details.
#
# Authors:
# 	2023	SeanHC Lin	<SeanHC.Lin@moxa.com>
# 	2023	Sin-Ru Lu 	<ChrisSR_lu@moxa.com>

if [ ! -v MODE ]; then
	echo "MODE not set, use default mode"
	MODE="0"
else
	if [ "$MODE" != "0" ] && [ "$MODE" != "1" ]; then
		echo "invalid MODE, use default mode"
		MODE="0"
	fi
fi

if [ "$MODE" == "0" ]; then
	ready_script="/etc/moxa-mil-base-system/moxa-sys-rdy.d/default.sh"
else
	ready_script="/etc/moxa-mil-base-system/moxa-sys-rdy.d/custom.sh"
fi

if [ ! -f "$ready_script" ]; then
	echo "ready script not found: $ready_script" >&2
	exit 1
fi

is_support_rdy="0"
is_support_alarm="0"

power_on() {
	if ! "$ready_script"; then
		echo "run ready script failed" >&2
		if [ "$is_support_rdy" == "1" ]; then
			if ! mx-interface-mgmt led RDY set_state off; then
				echo "turn off RDY led failed" >&2
			fi
		fi

		if [ "$is_support_alarm" == "1" ]; then
			if ! mx-interface-mgmt led ALARM set_state on; then
				echo "turn on ALARM led failed" >&2
			fi
		fi
		exit 1
	fi

	if [ "$is_support_rdy" == "1" ]; then
		if ! mx-interface-mgmt led RDY set_state on; then
			exit 1
		fi
	fi
}

power_off() {
	if [ "$is_support_alarm" == "1" ]; then
		if ! mx-interface-mgmt led ALARM set_state off; then
			exit 1
		fi
	fi

	if [ "$is_support_rdy" == "1" ]; then
		if ! mx-interface-mgmt led RDY set_state off; then
			exit 1
		fi
	fi
}

main() {
	if mx-interface-mgmt led RDY >/dev/null 2>&1; then
		is_support_rdy="1"
	fi

	if mx-interface-mgmt led ALARM >/dev/null 2>&1; then
		is_support_alarm="1"
	fi

	local srv_action="$1"
	if [ "$srv_action" == "on" ]; then
		power_on
	elif [ "$srv_action" == "off" ]; then
		power_off
	else
		echo "Usage: $0 [on|off]" >&2
		exit 1
	fi

	exit 0
}

main "$1"

exit 0
