#!/bin/bash
#
# Copyright (C) MOXA Inc. All rights reserved.
# This software is distributed under the terms of the MOXA SOFTWARE NOTICE.
# See the file MOXA-SOFTWARE-NOTICE for details.
#
# Authors:
# 	2023	Henry LC Chen <HenryLC.Chen@moxa.com>

device_tree_model_name=""

if [ -f "/proc/device-tree/model" ]; then
	device_tree_model_name="$(tr -d '\0' < /proc/device-tree/model)"
fi

if echo "${device_tree_model_name}" | grep -q "ioThinx"; then
	cp /lib/moxa-mil-base-system/iothinx_fw_env.config /etc/fw_env.config
else
	cp /lib/moxa-mil-base-system/fw_env.config /etc/fw_env.config
fi

exit 0
