#!/bin/bash
#
# based on http://theoldschooldevops.com/2008/02/09/bash-ini-parser/
#
# shellcheck disable=2086,2206,2128,SC2154,SC2116,SC2016,SC2155,SC2001,SC2295,SC2268

PREFIX="cfg_section_"

function debug {
    if ! [ "x$BASH_INI_PARSER_DEBUG" == "x" ]; then
        echo
        echo --start-- "$@"
        echo "${ini[*]}"
        echo --end--
        echo
    fi
}

cfg_transform_key() {
    local key=$1
    local transfor_key=$(echo "${key}" | sed ':b; s/^\([^=]*\)*\./\1_/; tb;')
    local val=
    transfor_key=$(echo "${transfor_key}" | sed ':b; s/^\([^=]*\)*\-/\1Q/; tb;')
    echo ${transfor_key}
}

cfg_reverse_key() {
    local key=$1
    local reverse_key=$(echo "${key}" | sed ':b; s/^\([^=]*\)*_/\1\./; tb;')
    local val=
    reverse_key=$(echo "${reverse_key}" | sed ':b; s/^\([^=]*\)*Q/\1\-/; tb;')
    echo ${reverse_key}
}

ini_get_value() {
    local key=${1}
    local transfor_key=$(echo "$key" | sed ':b; s/^\([^=]*\)*\./\1_/; tb;')
    transfor_key=$(echo "$transfor_key" | sed ':b; s/^\([^=]*\)*\-/\1Q/; tb;')

    eval "echo \${${transfor_key}[@]}"
}

ini_set_value() {
    local section=$1
    local key=$2
    local transfor_key=$(echo "${key}" | sed ':b; s/^\([^=]*\)*\./\1_/; tb;')
    local val=${3}
    transfor_key=$(echo "$transfor_key" | sed ':b; s/^\([^=]*\)*\-/\1Q/; tb;')

    eval "${transfor_key}='${val}'"
    cfg_update ${section} ${transfor_key}
}

function cfg_parser {
    shopt -p extglob &>/dev/null
    CHANGE_EXTGLOB=$?
    if [ $CHANGE_EXTGLOB = 1 ]; then
        shopt -s extglob
    fi
    unset ini
    ini="$(<$1)"       # read the file
    ini=${ini//$'\r'/} # remove linefeed i.e dos2unix

    ini="${ini//[/\\[}"
    debug "escaped ["
    ini="${ini//]/\\]}"
    debug "escaped ]"

    ini=$(echo "${ini[*]}" | sed ':b; s/^\([^=]*\)*\./\1_/; tb;')
    ini=$(echo "${ini[*]}" | sed ':b; s/^\([^=]*\)*\-/\1Q/; tb;')

    OLDIFS="$IFS"
    IFS=$'\n' && ini=(${ini}) # convert to line-array
    debug
    ini=(${ini[*]/#*([[:space:]]);*/})
    debug "removed ; comments"
    ini=(${ini[*]/#*([[:space:]])\#*/})
    debug "removed # comments"
    #ini=( ${ini[*]/#+([[:space:]])/} ) # remove init whitespace
    # Remove initial whitespace from each line using a loop and sed
    for i in "${!ini[@]}"; do
        ini[$i]=$(echo "${ini[$i]}" | sed 's/^[[:space:]]*//')
    done
    debug "removed initial whitespace"

    if [ $BASH_VERSINFO == 3 ]; then
        ini=(${ini[*]/+([[:space:]])=/=})               # remove whitespace before =
        ini=(${ini[*]/=+([[:space:]])/=})               # remove whitespace after =
        ini=(${ini[*]/+([[:space:]])=+([[:space:]])/=}) # remove whitespace around =
    else
        ini=(${ini[*]/*([[:space:]])=*([[:space:]])/=}) # remove whitespace around =
    fi
    debug "removed space around ="

    ini=(${ini[*]/#\\[/\}$'\n'"$PREFIX"}) # set section prefix
    debug
    for ((i = 0; i < "${#ini[@]}"; i++)); do
        line="${ini[i]}"
        if [[ "$line" =~ $PREFIX.+ ]]; then
            ini[$i]=${line// /_}
        fi
    done
    debug "subsections"
    ini=(${ini[*]/%\\]/ \(}) # convert text2function (1)
    debug
    ini=(${ini[*]/=/=\( }) # convert item to array
    debug
    ini=(${ini[*]/%/ \)}) # close array parenthesis
    debug
    ini=(${ini[*]/%\\ \)/ \\}) # the multiline trick
    debug
    ini=(${ini[*]/%\( \)/\(\) \{}) # convert text2function (2)
    debug
    ini=(${ini[*]/%\} \)/\}})                                          # remove extra parenthesis
    ini=(${ini[*]/%\{/\{$'\n''cfg_unset ${FUNCNAME/#'$PREFIX'}'$'\n'}) # clean previous definition of section
    debug
    ini[0]="" # remove first element
    debug
    ini[${#ini[*]} + 1]='}' # add the last brace
    debug

    eval "$(echo "${ini[*]}")" # eval the result
    EVAL_STATUS=$?
    if [ $CHANGE_EXTGLOB = 1 ]; then
        shopt -u extglob
    fi
    IFS="$OLDIFS"
    return $EVAL_STATUS
}

function cfg_writer {
    local item fun newvar vars
    SECTION=$1
    OLDIFS="$IFS"
    IFS=' '$'\n'
    if [ -z "$SECTION" ]; then
        fun="$(declare -F)"
    else
        fun="$(declare -F $PREFIX$SECTION)"
        if [ -z "$fun" ]; then
            echo "section $SECTION not found" 1>&2
            exit 1
        fi
    fi
    fun="${fun//declare -f/}"
    for f in $fun; do
        [ "${f#$PREFIX}" == "${f}" ] && continue
        item="$(declare -f ${f})"
        item="${item##*\{}"                  # remove function definition
        item="${item##*FUNCNAME*$PREFIX\};}" # remove clear section
        item="${item/FUNCNAME\/#$PREFIX;/}"  # remove line
        item="${item/%\}/}"                  # remove function close
        item="${item%)*}"                    # remove everything after parenthesis
        item="${item});"                     # add close parenthesis
        vars=""
        while [ "$item" != "" ]; do
            newvar="${item%%=*}" # get item name
            vars="$vars$newvar"  # add name to collection
            item="${item#*;}"    # remove readed line
        done
        vars=$(echo "$vars" | sort -u) # remove duplication
        eval $f
        local new_function_name=$(cfg_reverse_key ${f#$PREFIX})
        local commment_name=
        if [ -z "${INTERFACE_DEVICE_TYPE}" ]; then
            commment_name=Main_comment
        elif [ "${INTERFACE_DEVICE_TYPE}" = "WiFi-P2P" ]; then
            commment_name=WiFiP2P_comment
        else
            commment_name=${INTERFACE_DEVICE_TYPE}_comment
        fi
        comment_data=$(eval "echo \${${commment_name}[${new_function_name}]}")
        echo -e ${comment_data}

        echo "[${new_function_name}]" # output section
        for var in $vars; do
            eval 'local length=${#'$var'[*]}' # test if var is an array
            if [ $length == 1 ]; then
                new_var=$(cfg_reverse_key $var)
                comment_data=$(eval "echo -n \${${commment_name}[${new_var}]}")
                if [ -n "${comment_data}" ]; then
                    echo -e ${comment_data}
                fi

                echo $new_var=${!var} #output var
            else
                new_var=$(cfg_reverse_key $var)
                #echo ";${new_var} is an array" # add comment denoting var is an array
                eval 'echo ${new_var}=${'$var'[*]}' # output array var
            fi
        done
    done
    IFS="$OLDIFS"
}

function cfg_unset {
    local item fun newvar vars
    SECTION=$1
    OLDIFS="$IFS"
    IFS=' '$'\n'
    if [ -z "$SECTION" ]; then
        fun="$(declare -F)"
    else
        fun="$(declare -F $PREFIX$SECTION)"
        if [ -z "$fun" ]; then
            echo "section $SECTION not found" 1>&2
            return
        fi
    fi
    fun="${fun//declare -f/}"
    for f in $fun; do
        [ "${f#$PREFIX}" == "${f}" ] && continue
        item="$(declare -f ${f})"
        item="${item##*\{}"                  # remove function definition
        item="${item##*FUNCNAME*$PREFIX\};}" # remove clear section
        item="${item/%\}/}"                  # remove function close
        item="${item%)*}"                    # remove everything after parenthesis
        item="${item});"                     # add close parenthesis
        vars=""
        while [ "$item" != "" ]; do
            newvar="${item%%=*}" # get item name
            vars="$vars $newvar" # add name to collection
            item="${item#*;}"    # remove readed line
        done
        for var in $vars; do
            unset $var
        done
    done
    IFS="$OLDIFS"
}

function cfg_clear {
    SECTION=$1
    OLDIFS="$IFS"
    IFS=' '$'\n'
    if [ -z "$SECTION" ]; then
        fun="$(declare -F)"
    else
        fun="$(declare -F $PREFIX$SECTION)"
        if [ -z "$fun" ]; then
            echo "section $SECTION not found" 1>&2
            exit 1
        fi
    fi
    fun="${fun//declare -f/}"
    for f in $fun; do
        [ "${f#$PREFIX}" == "${f}" ] && continue
        unset -f ${f}
    done
    IFS="$OLDIFS"
}

function cfg_update {
    SECTION=$1
    VAR=$2
    OLDIFS="$IFS"
    IFS=' '$'\n'
    fun="$(declare -F $PREFIX$SECTION)"
    if [ -z "$fun" ]; then
        echo "section $SECTION not found" 1>&2
        exit 1
    fi

    fun="${fun//declare -f/}"
    item="$(declare -f ${fun})"
    #item="${item##* $VAR=*}" # remove var declaration
    item="${item/%\}/}" # remove function close
    item="${item}
    $VAR=(${!VAR})
   "
    item="${item}
   }" # close function again

    eval "function $item"
}

# vim: filetype=sh

#cfg_parser WiFi1.conf
#cfg_parser LAN1.conf
