#!/usr/bin/env bash

set -e

if [ "$MODE" = "debug" ]; then
  set -x
fi

source_environment_variables() {
  # get the directory of the script
  install_dir=$(dirname "$(dirname "$(readlink -f "$0")")")
  export install_dir
  if [ -f "${install_dir}/static-config/env-files/manifest.env" ]; then
    # shellcheck disable=SC2046
    export $(grep -v '^#' "${install_dir}/static-config/env-files/manifest.env" | xargs)
  fi
  if [ -f "${USER_DATA_DIR}/env-files/global.env" ]; then
    # shellcheck disable=SC2046
    export $(grep -v '^#' "${USER_DATA_DIR}/env-files/global.env" | xargs)
  fi
}

up() {
  echo "Add Remote Connect Port Range..."
  rc_service_port_start=$(/opt/moxa/dlm/bin/dlm config global RC_SERVICE_PORT_START)
  if [ -z "$rc_service_port_start" ]; then
    /opt/moxa/dlm/bin/dlm config global RC_SERVICE_PORT_START 50001
  fi

  rc_service_port_end=$(/opt/moxa/dlm/bin/dlm config global RC_SERVICE_PORT_END)
  if [ -z "$rc_service_port_end" ]; then
    /opt/moxa/dlm/bin/dlm config global RC_SERVICE_PORT_END 50010
  fi
}

down() {
  echo "Remove Remote Connect Port Range..."

  global_env_file="${USER_DATA_DIR}/env-files/global.env"

  if [ -f "$global_env_file" ]; then
    # Check if RC_SERVICE_PORT_START exists and remove it
    if grep -q "^RC_SERVICE_PORT_START=" "$global_env_file"; then
      echo "Removing RC_SERVICE_PORT_START from $global_env_file"
      sed -i '/^RC_SERVICE_PORT_START=/d' "$global_env_file"
    fi

    # Check if RC_SERVICE_PORT_END exists and remove it
    if grep -q "^RC_SERVICE_PORT_END=" "$global_env_file"; then
      echo "Removing RC_SERVICE_PORT_END from $global_env_file"
      sed -i '/^RC_SERVICE_PORT_END=/d' "$global_env_file"
    fi
  else
    echo "Global env file not found: $global_env_file"
  fi
}

main() {
  arg1=${1:-usage}

  case $arg1 in
  up)
    up
    ;;
  down)
    down
    ;;
  *)
    echo "Usage: $0 {up|down}"
    exit 1
    ;;
  esac
}

source_environment_variables
main "$@"
