CREATE TABLE IF NOT EXISTS monitored_device_props (
    id serial PRIMARY KEY,
    device_id int REFERENCES devices (id) NOT NULL,
    prop_name varchar(20) NOT NULL,
    prop_indexes int[],
    active boolean NOT NULL DEFAULT TRUE,
    UNIQUE (device_id, prop_name)
);

CREATE TABLE IF NOT EXISTS device_trendings (
    id bigserial PRIMARY KEY,
    property_id int REFERENCES monitored_device_props (id) NOT NULL,
    index int NOT NULL,
    time timestamptz NOT NULL DEFAULT NOW(),
    value float NOT NULL
);

CREATE OR REPLACE FUNCTION inactivate_device_trending ()
    RETURNS TRIGGER
    AS $$
BEGIN
    IF NEW.deleted THEN
        UPDATE
            monitored_device_props
        SET
            active = FALSE
        WHERE
            device_id = NEW.id;
    END IF;
    RETURN NEW;
END;
$$
LANGUAGE plpgsql;

CREATE TRIGGER device_trending_on_device_deleted
    BEFORE UPDATE OR INSERT ON devices
    FOR EACH ROW
    EXECUTE PROCEDURE inactivate_device_trending ();

