CREATE TABLE IF NOT EXISTS device_baseline_setting (
    enable boolean DEFAULT true,
    check_days int DEFAULT 180,
    created_time TIMESTAMP WITH TIME ZONE,
    audited_time TIMESTAMP WITH TIME ZONE
);

CREATE TABLE IF NOT EXISTS device_baselines (
    ip inet NOT NULL,
    device_id integer,
    baseline_content  BYTEA, -- running config
    baseline_config  BYTEA, -- config file
    baseline_fw_version  varchar(64),  -- firmware version
    baseline_created_at TIMESTAMP WITH TIME ZONE,
    baseline_config_status INT DEFAULT -1,
    baseline_fw_status INT DEFAULT -1,
    baseline_audited_at TIMESTAMP WITH TIME ZONE,
    config_audited_status INT DEFAULT -1,
    firmware_audited_status INT DEFAULT -1,
    latest_content  BYTEA, -- latest audit running config
    latest_fw_version  varchar(64), -- latest audit firmware version
    latest_fw_updated_at TIMESTAMP WITH TIME ZONE,
    latest_config_updated_at TIMESTAMP WITH TIME ZONE
);

