import { Injectable } from '@angular/core';
import { MatIconRegistry } from '@angular/material/icon';
import { DomSanitizer } from '@angular/platform-browser';

@Injectable({
  providedIn: 'root',
})
export class MxStyleService {
  constructor(
    private matIconRegistry: MatIconRegistry,
    private domSanitizer: DomSanitizer,
  ) {
    this.matIconRegistry.addSvgIcon(
      'file_download',
      this.domSanitizer.bypassSecurityTrustResourceUrl('../assets/img/file-download-outline.svg'));
    this.matIconRegistry.addSvgIcon(
      'file_upload',
      this.domSanitizer.bypassSecurityTrustResourceUrl('../assets/img/file-upload-outline.svg'));
    this.matIconRegistry.addSvgIcon(
      'person_off',
      this.domSanitizer.bypassSecurityTrustResourceUrl('../assets/img/person_off.svg'));
    this.matIconRegistry.addSvgIcon(
      'setting_warning',
      this.domSanitizer.bypassSecurityTrustResourceUrl('../assets/img/setting_warning.svg'));
    this.matIconRegistry.addSvgIcon(
      'table_arrow_down',
      this.domSanitizer.bypassSecurityTrustResourceUrl('../assets/img/table-arrow-down.svg'));
  }
}
